CONTAINER OClumpModifier
{
	NAME OClumpModifier;
	INCLUDE Obase;
	
	GROUP ID_OBJECTPROPERTIES
	{
		STRING clump_StrandGroupAttribute {}
		
		//----------------------------------------------
		SEPARATOR { LINE; }
		
		REAL clump_AmountAttribute
		{
			CUSTOMGUI REALSLIDER;
			MINSLIDER 0.0;
			MAXSLIDER 1.0;
			STEP 0.01;
		}
		
		SPLINE clump_AmountCurveAttribute {}
		
		SHADERLINK clump_AmountMultiplierAttribute {}
		
		LONG clump_AmountChannelAttribute {}
		
		BOOL clump_PreserveStrandLengthsAttribute {}
		
		BOOL clump_AttractToClosestStemPointAttribute {}
		
        //----------------------------------------------
        SEPARATOR { LINE; }

        BOOL clump_UseUvSpaceAttribute {}
        LONG clump_UvChannelIndexAttribute
        {
            MIN 0;
            MAX 100;
            ANIM OFF;
        }
		
		//----------------------------------------------
		SEPARATOR { LINE; }
		
		REAL clump_TwistAttribute
		{
			CUSTOMGUI REALSLIDER;
			MINSLIDER -10.0;
			MAXSLIDER 10.0;
			STEP 0.01;
		}
		
		SPLINE clump_TwistCurveAttribute {}
		
		SHADERLINK clump_TwistMultiplierAttribute {}
		
		LONG clump_TwistChannelAttribute {}
		
		//----------------------------------------------
		SEPARATOR { LINE; }
		
		REAL clump_FlyawayFractionAttribute
		{
			CUSTOMGUI REALSLIDER;
			MIN 0.0;
			MAX 1.0;
			STEP 0.01;
		}
		
		REAL clump_FlyawayAmountAttribute
		{
			CUSTOMGUI REALSLIDER;
			MINSLIDER 0.0;
			MAXSLIDER 1.0;
			STEP 0.01;
		}
		
		//----------------------------------------------
		SEPARATOR { LINE; }
		
		BOOL clump_SetClumpSizeAttribute {}
		
		REAL clump_ClumpSizeAttribute
		{
			CUSTOMGUI REALSLIDER;
			MIN 0.0;
			MAXSLIDER 100.0;
			STEP 0.01;
		}
		
		SPLINE clump_ClumpSizeCurveAttribute {}
		
		//----------------------------------------------
		
		GROUP clump_SubClumping_Group
		{
			DEFAULT 1;
			
			SHADERLINK clump_RegionMultiplierAttribute {}
			
			LONG clump_RegionChannelAttribute {}
			
			BOOL clump_AddClumpIndexChannelAttribute
			{
				ANIM OFF;
			}
			
			LONG clump_RegionClumpCandidatesAttribute
			{
				CUSTOMGUI LONGSLIDER;
				MIN 1;
				MAXSLIDER 100;
				ANIM OFF;
			}
			
			REAL clump_RegionDifferenceThresholdAttribute
			{
				CUSTOMGUI REALSLIDER;
				MIN 0.0;
				MAX 1.0;
				STEP 0.01;
			}
			
			BOOL clump_RespectHairPartsAttribute {}
			
		}

		
		
		//----------------------------------------------
		// Arrays
		
		VECTOR_ARRAY clump_ClumpBarycentricCoordinatesAttribute {}
		LONG_ARRAY clump_ClumpFaceIndicesAttribute {}
		VECTOR_ARRAY clump_RootBarycentricCoordinatesAttribute {}
		LONG_ARRAY clump_RootFaceIndicesAttribute {}
		LONG_ARRAY clump_RootClosestClumpIndicesAttribute {}
		LONG_ARRAY clump_ClumpHairSelectionAttribute {}
		LONG_ARRAY clump_ClumpSelectionAttribute {}
		LONG_ARRAY clump_ClumpGuideBaseStrandIdsAttribute {}
		LONG_ARRAY clump_ClumpCenterBaseStrandIdsAttribute {}
		LONG_ARRAY clump_ClumpCenterGuideIdsAttribute {}
		
		//----------------------------------------------
		// Inputs / Outputs
		
		SEPARATOR { LINE; }
		
		GROUP clump_PLUGS {}
	}
	
	//===============================================
	GROUP clump_Clumps_Group
	{
		DEFAULT 0;
		
		LONG clump_ClumpGenerationMethodAttribute
		{
			CYCLE
			{
				clump_ClumpGenerationMethod_Random;
				clump_ClumpGenerationMethod_StrandGroups;
				clump_ClumpGenerationMethod_Guides;
				clump_ClumpGenerationMethod_ExternalClumpStrands;
			};
		}
		
		LONG clump_ClumpCountAttribute
		{
			CUSTOMGUI LONGSLIDER;
			MIN 1;
			MAXSLIDER 50;
			ANIM OFF;
		}
		
		LONG clump_RandomSeedAttribute
		{
			CUSTOMGUI LONGSLIDER;
			MIN 1;
			MAXSLIDER 1000;
		}
		
		LINK clump_ExternalClumpStrandsAttribute
		{
			ACCEPT
			{
				1050340;	// ID_OX_HAIR_OBJECT
			}
		}
		
		//----------------------------------------------
		SEPARATOR { LINE; }

		LONG clump_ClumpEditMode
		{
			HIDDEN;
			
			CYCLE
			{
				clump_ClumpEditMode_None;
				clump_ClumpEditMode_ClumpHairs;
				clump_ClumpEditMode_Clumps;
			};
		}
		
		GROUP
		{
			COLUMNS 2;
			
			BITMAPBUTTON clump_Button_CreateClumps { OPEN; }
			BITMAPBUTTON clump_Button_DeleteClumps { OPEN; }
			
			BITMAPBUTTON clump_Button_ClumpHairEditing { OPEN; }
			BITMAPBUTTON clump_Button_ClumpEditing { OPEN; }
		}

		GROUP
		{
			COLUMNS 2;
			
			BUTTON clump_Button_SelectStrandsTool {}
			BUTTON clump_Button_SelectStrandsRectTool {}
			BUTTON clump_Button_SelectStrandsAll { HIDDEN; }
			BUTTON clump_Button_SelectStrandsNone { HIDDEN; }
		}
		
		LONG clump_SelectToolRadius
		{
			CUSTOMGUI LONGSLIDER;
			MIN 1;
			MAX 100;
			ANIM OFF;
		}
		
		LONG clump_SubSelectionCount
		{
			ANIM OFF;
			STEP 0;
		}

		//----------------------------------------------
		SEPARATOR { LINE; }
		
		REAL clump_RootBlendingPositionAttribute
		{
			CUSTOMGUI REALSLIDER;
			MIN 0.0;
			MAX 1.0;
			STEP 0.01;
		}
		
		BOOL clump_RoundClumpsAttribute {}
		
		//----------------------------------------------
		GROUP clump_ClumpPatterns_Group
		{
			DEFAULT 1;
			
			IN_EXCLUDE clump_PatternsAttribute
			{
				NUM_FLAGS 1;
				INIT_STATE 1;
				
				IMAGE_01_ON 300000131;
				IMAGE_01_OFF 300000130;
				
				ACCEPT
				{
					1050340;	// ID_OX_HAIR_OBJECT
				}
			}
			
			// Filled with indices from pattern list
			LONG_ARRAY clump_PatternIndicesAttribute { HIDDEN; }
			
			REAL clump_ClumpPatternRotationAttribute
			{
				UNIT DEGREE;
				CUSTOMGUI REALSLIDER;
				MINSLIDER -180.0;
				MAXSLIDER 180.0;
				STEP 0.1;
			}
		}

		//----------------------------------------------
		GROUP clump_PerClump_Group
		{
			DEFAULT 1;
			
			BITMAPBUTTON clump_Button_ResetClumps { OPEN; }

			REAL clump_AmountOverrideAttribute
			{
				CUSTOMGUI REALSLIDER;
				MINSLIDER 0.0;
				MAXSLIDER 1.0;
				STEP 0.01;
				ANIM OFF;
			}
			
			SPLINE clump_ClumpAmountCurveOverrideAttribute
			{
				ANIM OFF;
			}
			
			REAL clump_TwistOverrideAttribute
			{
				CUSTOMGUI REALSLIDER;
				MINSLIDER -10.0;
				MAXSLIDER 10.0;
				STEP 0.01;
				ANIM OFF;
			}
			
			SPLINE clump_ClumpTwistCurveOverrideAttribute
			{
				ANIM OFF;
			}
			
			LONG clump_PatternIndicesOverrideAttribute
			{
				HIDDEN;
				ANIM OFF;
				// Setup by FillPatternOverrideList()
				//CUSTOMGUI LONGSLIDER;
				//MIN -1;
				//MAX 2;
			}

			// Saved by clumper
			
			LONG_ARRAY clump_PerClumpIndicesAttribute {}
			REAL_ARRAY clump_PerClumpAmountsAttribute {}
			LONG_ARRAY clump_ClumpAmountCurveKnotCountsAttribute {}
			REAL_ARRAY clump_ClumpValueCurvesPositionsAttribute {}
			REAL_ARRAY clump_ClumpValueCurvesValuesAttribute {}
			LONG_ARRAY clump_ClumpValueCurvesInterpolationsAttribute {}
			REAL_ARRAY clump_PerClumpTwistsAttribute {}
			LONG_ARRAY clump_ClumpTwistCurveKnotCountsAttribute {}
			REAL_ARRAY clump_ClumpTwistCurvesPositionsAttribute {}
			REAL_ARRAY clump_ClumpTwistCurvesValuesAttribute {}
			LONG_ARRAY clump_ClumpTwistCurvesInterpolationsAttribute {}
			LONG_ARRAY clump_PerClumpPatternIndicesAttribute {}
		}
	}

	INCLUDE OBakeableInterface;
}
